<?php
header('Content-Type: application/json');

// **¡IMPORTANTE! Configura estos datos con los de tu base de datos MySQL**
$servername = "162.240.101.211"; // Generalmente 'localhost' o la IP/dominio que te dio tu hosting para MySQL
$username = "maquino_test"; // El usuario de tu base de datos MySQL
$password = "USCXJE72EE671SYA"; // La contraseña de tu usuario MySQL
$dbname = "maquino_mailgun"; // El nombre de tu base de datos

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "Error de conexión: " . $conn->connect_error]);
    exit();
}


$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['emails']) || !is_array($data['emails'])) {
    http_response_code(400);
    echo json_encode(["status" => "error", "message" => "Datos de 'emails' no validos."]);
    exit();
}

$emailsToDelete = $data['emails'];
$deletedCount = 0;
$errors = [];

$stmt = $conn->prepare("DELETE FROM user WHERE correo = ?");
if (!$stmt) {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "Error al preparar la sentencia: " . $conn->error]);
    exit();
}
$stmt->bind_param("s", $email);

foreach ($emailsToDelete as $email) {
    if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $email = trim($email);
        $stmt->execute();
        if ($stmt->affected_rows > 0) {
            $deletedCount++;
        } else {
            $errors[] = "No se encontró o eliminó el correo: " . $email;
        }
    } else {
        $errors[] = "Formato de correo inválido: " . $email;
    }
}

$stmt->close();
$conn->close();

http_response_code(200);
echo json_encode([
    "status" => "success",
    "message" => "Operación completada.",
    "deleted_count" => $deletedCount,
    "errors" => $errors
]);
?>